// bfs.java
// demonstracja wyszukiwania "wszerz"
// aby uruchomi program: C:>java BFSApp (wersja angielska)
// aby skompilowa wersj polsk: C:>javac bfs.java
// po kompilacji:         C:>java BFSApp
////////////////////////////////////////////////////////////////
class Queue
   {
   private final int SIZE = 20;
   private int[] queArray;
   private int front;
   private int rear;
// -------------------------------------------------------------
   public Queue()            // konstruktor
      {
      queArray = new int[SIZE];
      front = 0;
      rear = -1;
      }
// -------------------------------------------------------------
   public void insert(int j) // umie element na kocu kolejki
      {
      if(rear == SIZE-1)
         rear = -1;
      queArray[++rear] = j;
      }
// -------------------------------------------------------------
   public int remove()       // pobierz element z pocztku kolejki
      {
      int temp = queArray[front++];
      if(front == SIZE)
         front = 0;
      return temp;
      }
// -------------------------------------------------------------
   public boolean isEmpty()  // 'prawda' jeeli kolejka jest pusta
      {
      return ( rear+1==front || (front+SIZE-1==rear) );
      }
// -------------------------------------------------------------
   }  // end class Queue
////////////////////////////////////////////////////////////////
class Vertex
   {
   public char label;        // etykieta (np. 'A')
   public boolean wasVisited;
// -------------------------------------------------------------
   public Vertex(char lab)   // konstruktor
      {
      label = lab;
      wasVisited = false;
      }
// -------------------------------------------------------------
   }  // end class Vertex
////////////////////////////////////////////////////////////////
class Graph
   {
   private final int MAX_VERTS = 20;
   private Vertex vertexList[]; // lista wierzchokw
   private int adjMat[][];      // matryca przylegania
   private int nVerts;          // bieca liczba wierzchokw
   private Queue theQueue;
// ------------------------------------------------------------
   public Graph()               // konstruktor
      {
      vertexList = new Vertex[MAX_VERTS];
                                          // matryca przylegania
      adjMat = new int[MAX_VERTS][MAX_VERTS];
      nVerts = 0;
      for(int j=0; j<MAX_VERTS; j++)      // zerowanie matrycy
         for(int k=0; k<MAX_VERTS; k++)   //       przylegania
            adjMat[j][k] = 0;
      theQueue = new Queue();
      }  // end constructor
// -------------------------------------------------------------
   public void addVertex(char lab)
      {
      vertexList[nVerts++] = new Vertex(lab);
      }
// -------------------------------------------------------------
   public void addEdge(int start, int end)
      {
      adjMat[start][end] = 1;
      adjMat[end][start] = 1;
      }
// -------------------------------------------------------------
   public void displayVertex(int v)
      {
      System.out.print(vertexList[v].label);
      }
// -------------------------------------------------------------
   public void bfs()                   // wyszukiwanie "wszerz"
      {                                // rozpocznij od wierzchoka 0
      vertexList[0].wasVisited = true; // oznacz wierzchoek
      displayVertex(0);                // wywietl wierzchoek
      theQueue.insert(0);              // wstaw na kocu
      int v2;

      while( !theQueue.isEmpty() )     // do oprnienia kolejki,
         {
         int v1 = theQueue.remove();   // usu piewszy wierzchoek
         // dopki ma nie odwiedzonych ssiadw
         while( (v2=getAdjUnvisitedVertex(v1)) != -1 )
            {                                  // pobierz jednego,
            vertexList[v2].wasVisited = true;  // oznacz
            displayVertex(v2);                 // wywietl
            theQueue.insert(v2);               // wstaw
            }   // end while
         }  // end while(kolejka nie jest pusta)

      // skonczone, gdy kolejka jest pusta
      for(int j=0; j<nVerts; j++)             // zeruj znaczniki
         vertexList[j].wasVisited = false;
      }  // end bfs()
// -------------------------------------------------------------
   // zwraca nie odwiedzony wierzchoek przylegy do v
   public int getAdjUnvisitedVertex(int v)
      {
      for(int j=0; j<nVerts; j++)
         if(adjMat[v][j]==1 && vertexList[j].wasVisited==false)
            return j;
      return -1;
      }  // end getAdjUnvisitedVertex()
// -------------------------------------------------------------
   }  // end class Graph
////////////////////////////////////////////////////////////////
class BFSApp
   {
   public static void main(String[] args)
      {
      Graph theGraph = new Graph();
      theGraph.addVertex('A');    // 0  (pocztek wyszukiwania)
      theGraph.addVertex('B');    // 1
      theGraph.addVertex('C');    // 2
      theGraph.addVertex('D');    // 3
      theGraph.addVertex('E');    // 4

      theGraph.addEdge(0, 1);     // AB
      theGraph.addEdge(1, 2);     // BC
      theGraph.addEdge(0, 3);     // AD
      theGraph.addEdge(3, 4);     // DE

      System.out.print("Odwiedzone wierzchoki: ");
      theGraph.bfs();             // wyszukiwanie "wszerz"
      System.out.println();
      }  // end main()
   }  // end class BFSApp
////////////////////////////////////////////////////////////////

